﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace Cool_Muscle_CML_Example
{
    public partial class Form1 : Form
    {
        delegate void setPointCallBack(string sReceived); // handle thread 

        public Form1()
        {
            InitializeComponent();
        }

        private void button_OpenComm_Click(object sender, EventArgs e)
        {
            serialPort.PortName = "COM" + textBox_PortNum.Text;
            serialPort.BaudRate = 38400;
            serialPort.Parity = Parity.None;
            serialPort.DataBits = 8;
            serialPort.StopBits = StopBits.One;

            try
            {
                serialPort.Open();
            }
            catch 
            {
                MessageBox.Show("Communication port did not open. Please check settings.");           
            }
        }

        private void button_Start_Click(object sender, EventArgs e)
        {
            /* Run the motor using the dynamic move structure
             * Set P0, S0, A0 and M0. Then start the motor with the ^ command
             * We assume a single motor in this example so use the .1 ID
             * P, S, A and M are separated with a comma (,)
             * All instructions must be appended with a carriage return
             */

            String sSend;

            sSend = "P0.1=" + textBox_Position.Text +
                    ",S0.1=" + textBox_Speed.Text +
                    ",A0.1=" + textBox_Acceleration.Text +
                    ",M0.1=" + textBox_Torque.Text +
                    "\r";

            //write the registers data
            serialPort.Write(sSend);

            //start the motor
            serialPort.Write("^.1\r");

        }

        private void button_Stop_Click(object sender, EventArgs e)
        {
            /* Stop the motor with the ] command. 
             * We assume a single motor in this example so use the .1 ID
             * All commands must be appended with a carriage return
             */

            serialPort.Write("].1\r");
        }

        private void button_Clear_Click(object sender, EventArgs e)
        {   
            //clear the received textbox
            textBox_Received.Text = "";
        }

        private void serialPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            string recData;

            recData = serialPort.ReadExisting();

            //Handle cross threads
            if (textBox_Received.InvokeRequired)
            {
                setPointCallBack d = new setPointCallBack(DisplayData);
                this.Invoke(d, new object[] { recData });
            }
            else textBox_Received.Text += recData;
        }

        private void DisplayData(string sReceived)
        {
            textBox_Received.Text += sReceived;
        }

    }
}
